﻿using System;
using System.Linq;
using AvWorksBrowser.AdvWorksData;
using System.Collections.Generic;

namespace AvWorksBrowser
{
    public class CategoryViewModel
    {
        private ProductCategory entity;

        private CategoryViewModel(ProductCategory categoryEntity)
        {
            entity = categoryEntity;
        }

        public static void GetCategories(Action<IList<CategoryViewModel>> categoriesFetchedCallback)
        {
            Uri dataUri = new Uri(App.Current.Host.Source, "/AdventureWorksData.svc");
            AdventureWorksLT2008Entities dataServiceContext = new AdventureWorksLT2008Entities(dataUri);

            // Wywołanie Expand("Product") stwierdza "a skoro już tam jesteś, to pobierz wszystkie
            // powiązane encje Product".
            // Jest ono podobne (i z tajemniczych powodów ma inną nazwę) do metody Include EF.

            // Powinniśmy mieć możliwość filtrowania dostępnych produktów, ale oto do czego 
            // doszliśmy podczas prób napisania odpowiedniego zapytania LINQ:
            // ProductCategory()?$filter=Product/Count gt 0&$expand=Products
            // ADO.NET DS zwraca błąd 404 ponieważ nie wie czym jest wyrażenie
            // Product/Count. Dlatego też po uzyskaniu wyników musimy je filtrować
            // po stronie klienta.
            var q = dataServiceContext.ProductCategories.Expand("Products");
            q.BeginExecute(delegate(IAsyncResult iar)
            {
                var categories = q.EndExecute(iar);
                var categoryViewModels = from category in categories
                                         where category.Products.Count > 0
                                         select new CategoryViewModel(category);

                categoriesFetchedCallback(categoryViewModels.ToArray());
            }, null);

        }

        public string DisplayName { get { return entity.Name; } }

        private ProductViewModel[] cachedProducts;

        public IList<ProductViewModel> Products
        {
            get
            {
                if (cachedProducts == null)
                {
                    cachedProducts = (from product in entity.Products
                                      select new ProductViewModel(product)).ToArray();
                }

                return cachedProducts;
            }
        }

    }
}
